/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client;

import com.google.common.collect.Lists;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;

public class FontUtil {
    public static List<String> drawSplitStringOverflow(FontRenderer fontRenderer, String str, int x, int y, int wrapWidth, int threshold, int textColor, boolean addShadow) {
        List strs = fontRenderer.func_78271_c(str, wrapWidth);
        return FontUtil.drawSplitStringOverflow(fontRenderer, strs, x, y, wrapWidth, threshold, textColor, addShadow);
    }

    public static List<String> drawSplitStringOverflow(FontRenderer fontRenderer, List<String> strs, int x, int y, int wrapWidth, int threshold, int textColor, boolean addShadow) {
        threshold += y;
        for (int i = 0; i < strs.size(); ++i) {
            if ((y += fontRenderer.field_78288_b) >= threshold && i < strs.size() - 1) {
                return strs.subList(i, strs.size());
            }
            FontUtil.renderStringAligned(fontRenderer, strs.get(i), x, y, wrapWidth, textColor, addShadow);
        }
        return Lists.newArrayList();
    }

    private static String trimStringNewline(String text) {
        while (text != null && text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private static int renderStringAligned(FontRenderer fontRenderer, String text, int x, int y, int width, int color, boolean dropShadow) {
        if (fontRenderer.func_78260_a()) {
            int i = fontRenderer.func_78256_a(FontUtil.bidiReorder(text));
            x = x + width - i;
        }
        return fontRenderer.func_175065_a(text, (float)x, (float)y, color, dropShadow);
    }

    private static String bidiReorder(String text) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(text), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException var3) {
            return text;
        }
    }
}

